<?php
/**
***************************************************************************************************
 * @Software    ClipBucket
 * @Author      Arslan Hassan, et al
 * @Copyright	Copyright (c) 2007-2008. All Rights Reserved.
 * @URL        	http://www.clip-bucket.com
 * @Version		$Id: TConfig.php 235 2009-08-25 12:39:17Z fwhite $
 * @Created 	10-15-2007
 * @License		CBLA v1 - http://cbla.cbdev.org
 **************************************************************************************************
 This source code is licensed under the terms of the CBLA v1
 http://cbla.cbdev.org
 **************************************************************************************************
 Copyright (c) 2007-2008 Clip-Bucket.com. All Rights Reserved.
 **************************************************************************************************
 **/
 
define ("CONF_COMMENT", "#");

class TConfig {
    var $_def_file_name;
    var $_filename;
    var $_TConfig;
    var $_errors;

    function TConfig() {
        global $TConfig;
        if (!isset($TConfig)) $TConfig = $this;
        $TConfig->_init();
    }

    function create() {
        return new TConfig();
    }

    function _init () {
	  global $config;	
 	  $this->_def_file_name = $config[CONF_FILE];
        $filename = $this->_def_file_name;
        $this->_filename = $filename;

        if (!$file = $this->_read_file()) return false;
            $ar = explode("\n", $file);

        foreach ($ar as $item) {
            if (eregi("\[.*\]", $item)) {
                $section = trim(eregi_replace("\[|\]", "", $item));
            } else {
                $key   = trim(substr($item, 0, strpos($item, "=")));
                $value = trim(substr($item, strpos($item, "=")+1));
                if ($key and !eregi("[[::space::]]*".CONF_COMMENT, $item)) {
                    $res[$section][$key] = $value;
                }
            }
        }
        $this->_TConfig = $res;
    }

    function _check_TConfig_loaded () {
        if (isset($this->_TConfig)) {
            return true;
        } else {
            TError::add("TConfiguration file hasen't been loaded");
            return false;
        }
    }

    function get ($section, $key) {
        global $TConfig;
        if (!isset($TConfig)) {
            TConfig::create();
        }
        if (!$TConfig->_check_TConfig_loaded()) {
            return false;
        }
        return $TConfig->_TConfig[$section][$key];
    }

    function getSection ($section) {
        global $TConfig;
        if (!isset($TConfig)) {
            TConfig::create();
        }
        if (!$TConfig->_check_TConfig_loaded()) {
            return false;
        }
        if (!isset($TConfig->_TConfig[$section])) {
            TError::add("Section $section does not exist");
            return false;
        }
        return $TConfig->_TConfig[$section];
    }

    function getAll () {
        global $TConfig;
        if (!isset($TConfig)) {
            TConfig::create();
        }
        if (!$TConfig->_check_TConfig_loaded()) {
            return false;
        }
        return $TConfig->_TConfig;
    }

    function checkSection ($section) {
        global $TConfig;
        if (!isset($TConfig)) {
            TConfig::create();
        }
        if (!$TConfig->_check_TConfig_loaded()) {
            return false;
        }
        return (isset($TConfig->_TConfig[$section]));
    }

    function set ($section, $key, $value, $create = true, $is_write = true) {
        global $TConfig;
        if (!isset($TConfig)) {
            TConfig::create();
        }

        if (!$TConfig->_check_TConfig_loaded()) {
            return false;
        }
        if (!$TConfig->checkSection($section)) {
            TError::add("Invalid section name \"$section\"");
            return false;
        }
        if (isset($this->_TConfig[$section][$key])) {
            $TConfig->_TConfig[$section][$key] = $value;
        } else {
            if ($create) {
                $TConfig->_TConfig[$section][$key] = $value;
            } else {
                TError::add("Unable to create new key");
                return false;
            }
        }
        if ($is_write) {
           $TConfig->_write();
        }
        return true;
    }

    function write ($filename = null) {
        global $TConfig;
        if (!isset($TConfig)) {
            TConfig::create();
        }

        if (!$TConfig->_check_TConfig_loaded()) {
            return false;
        }
        if (!$filename) {
            $filename = $TConfig->_filename;
        }

        $out = "";
        foreach ($this->_TConfig as $section => $values) {
            $out .= "[$section]\n";
            foreach ($values as $key => $value) {
                $out .= "$key = $value\n";
            }
        }
        if (is_writable($filename)) {
            if (!$fp = fopen($filename, 'w')) {
                TError::add("Cannot open file ($filename)");
                return false;
            }
            if (!fwrite($fp, $out)) {
                TError::add("Cannot write to file ($filename).");
                return false;
            }
            fclose($fp);
        } else {
            TError::add("The file $filename is not writable.");
            return false;
        }
        return true;
    }

    function _read_file () {
        global $TConfig;
        if (!isset($TConfig)) {
            TConfig::create();
        }

        if (!file_exists($TConfig->_filename)) {
            TError::add("file ".$TConfig->_filename." does not exists.");
            return false;
        }
        $fd = fopen ($TConfig->_filename, "r");
        if (!$fd) {
            TError::add("error opening file for reading");
            return false;
        }

        $buffer = "";
        while (!feof ($fd)) {
            $buffer .= fgets($fd, 4096);
        }
        fclose ($fd);
        $buffer = eregi_replace("\n\n", "\n", $buffer);
        return $buffer;
    }

    function getErrors () {
        return TError::getErrors();
    }
}
?>