<?php
/**
#########################################################################################################
# Copyright (c) 2009 ClipBucket / PHPBucket.com. All Rights Reserved.
# URL:              [url]http://clip-bucket.com[/url]
# Function:         e-mail contact form handling
# Author:           fwhite
# Language:         PHP
# License:          CBLA @ [url]http://cbla.cbdev.org/[/url]
# Version:          $Id: contact.class.php 241 2009-08-26 10:45:58Z fwhite $
# Created:          February 24, 2009 / 07:53 PM GMT+1 (fwhite)
# Last Modified:    August 26, 2009 / 01:53 AM GMT+1 (fwhite)
# Notice:           Please maintain this section
#########################################################################################################
*/

class contact {

/**
Validate an email address.
Provide email address (raw input)
Returns true if the email address has the email
address format and the domain exists.
*/

function isValidEmail($email)
{
   $isValid = true;
   $atIndex = strrpos($email, "@");
   if (is_bool($atIndex) && !$atIndex)
   {
      $isValid = false;
   }
   else
   {
      $domain = substr($email, $atIndex+1);
      $local = substr($email, 0, $atIndex);
      $localLen = strlen($local);
      $domainLen = strlen($domain);
      if ($localLen < 1 || $localLen > 64)
      {
         // local part length exceeded
         $isValid = false;
      }
      else if ($domainLen < 1 || $domainLen > 255)
      {
         // domain part length exceeded
         $isValid = false;
      }
      else if ($local[0] == '.' || $local[$localLen-1] == '.')
      {
         // local part starts or ends with '.'
         $isValid = false;
      }
      else if (preg_match('/\\.\\./', $local))
      {
         // local part has two consecutive dots
         $isValid = false;
      }
      else if (!preg_match('/^[A-Za-z0-9\\-\\.]+$/', $domain))
      {
         // character not valid in domain part
         $isValid = false;
      }
      else if (preg_match('/\\.\\./', $domain))
      {
         // domain part has two consecutive dots
         $isValid = false;
      }
      else if
(!preg_match('/^(\\\\.|[A-Za-z0-9!#%&`_=\\/$\'*+?^{}|~.-])+$/',
                 str_replace("\\\\","",$local)))
      {
         // character not valid in local part unless
         // local part is quoted
         if (!preg_match('/^"(\\\\"|[^"])+"$/',
             str_replace("\\\\","",$local)))
         {
            $isValid = false;
         }
      }
      if ($isValid && !(checkdnsrr($domain,"MX") ||
      checkdnsrr($domain,"A")))
      {
         // domain not found in DNS
         $isValid = false;
      }
   }
   return $isValid;
}

	function isDisposableEmail($email){
      if ((stristr($email,"spamgourmet")!="")||(stristr($email,"mailinator")!="")||(stristr($email,"jetable")!="") ||
      (stristr($email,"anonymouse")!="") || (stristr($email,"guerrillamail")!="") ||
      (stristr($email,"mt2009")!="") || (stristr($email,"mailexpire")!="") ||
      (stristr($email,"spambox")!=""))
       {
       return true;
       }
        else
        {
         return false;
        }
   }

	//Validate Username

	function isValidUsername($uname){
      $pattern = "^^[_a-z0-9-]+$";
      if (eregi($pattern, $uname)){
         return true;
      	}else {
         return false;
      }
   }

	//This Function Is Used To Check Regiseration is allowed or not
	function Allow_Contact(){
			if(ALLOW_CONTACT == 1 ){
			return true;
			}else{
			return false;
			}
		}

	//Validate Form Fields And Add Member
	
	function sendContact(){
	if($this->Allow_Contact()){
	$uname 		= mysql_clean($_POST['username']);
	$email		= mysql_clean($_POST['email']);
    $message	= mysql_clean($_POST['message']);
	$sender_ip	= $_SERVER['REMOTE_ADDR'];
	
	//Check User
	if(empty($uname)){
	$msg[] = 'Point of Contact not specified';
	}
	
	// Check Message
	if(empty($_POST['message'])){
	$msg[] = 'Message not entered';
	}

    if(!empty($_POST['message']) && strlen($_POST['message']) <= 9){
	$msg[] = 'Message is shorter than 10 characters';
	}
	
	//Check Email
	if(empty($email)){
	$msg[] = 'e-mail address not specified';
	}elseif(!$this->isValidEmail($email)){
	$msg[] = 'Please enter a valid e-mail address';
	}
    elseif($this->isDisposableEmail($email)){
	$msg[] = 'Disposable e-mail addresses are not permitted';
	}
	
		if(empty($msg)){
			$username 	= $uname;
			$cur_date	= date("l, F d, Y / h:i:s A T (O)");
			$title		= TITLE;
			$from		= $email;
            $to         = SUPPORT_EMAIL;
            $subj 	    = 'Contact Form Message from '.$username.' @ '.$title;
            $header     = "From: ". $username . " <" . $from . ">\r\n"; //optional headerfields

			require_once(BASEDIR.'/includes/email_templates/send_contact.template.php');
			require_once(BASEDIR.'/includes/email_templates/send_contact.header.php');
			//send_email($from,$to,$subj,stripslashes($body));
            ini_set('sendmail_from', $email);
            mail($to, $subj, $body, $header);

		$msg = 'success';
		}
	
		}else{
		$msg = "Sorry, the contact form has been disabled by the system administrator.";
		}
	return $msg;
		
	}

}
?>