<?php
/**
***************************************************************************************************
 * @Software    ClipBucket
 * @Author      Arslan Hassan, et al
 * @Copyright	Copyright (c) 2007-2008. All Rights Reserved.
 * @URL        	http://www.clip-bucket.com
 * @Version		$Id: image.class.php 235 2009-08-25 12:39:17Z fwhite $
 * @Created 	10-15-2007
 * @License		CBLA v1 - http://cbla.cbdev.org
 **************************************************************************************************
 This source code is licensed under the terms of the CBLA v1
 http://cbla.cbdev.org
 **************************************************************************************************
 Copyright (c) 2007-2008 Clip-Bucket.com. All Rights Reserved.
 **************************************************************************************************
 **/
 
class ResizeImage
{

	// image resize
	function CreateThumb($file,$des,$dim,$ext,$dim_h=NULL,$aspect_ratio=true){
	$array = getimagesize($file);
	$width_orig= $array[0];
	$height_orig= $array[1];

	if($width_orig > $height_orig)
	$ratio= $width_orig/$dim;
	else $ratio=$height_orig/$dim;
	
	$width=$width_orig/$ratio;
	$height=$height_orig/$ratio;
	
	if($aspect_ratio == false && $dim_h !=''){
	$width = $dim;
	$height = $dim_h;
	}

    $ext = strtolower($ext);
	$image_p = imagecreatetruecolor($width, $height);
	
	if($ext=='jpg' || $ext=='jpeg'){
	$image = imagecreatefromjpeg($file);
	imagecopyresampled($image_p, $image, 0, 0, 0, 0, $width, $height, $width_orig, $height_orig);
	imagejpeg($image_p,$des, 90);
	}
	elseif($ext=='png'){
	$image = imagecreatefrompng($file);
	imagecopyresampled($image_p, $image, 0, 0, 0, 0, $width, $height, $width_orig, $height_orig);
	imagepng($image_p,$des);
	}
	elseif($ext=='gif'){
	$image = imagecreatefromgif($file);
	imagecopyresampled($image_p, $image, 0, 0, 0, 0, $width, $height, $width_orig, $height_orig);
	imagegif($image_p,$des, 90);
	}
	}
	
	// Validate uploaded image
	
	function ValidateImage($file,$ext=NULL){
	$ext = strtolower($ext);
	$array = getimagesize($file);	
	if($ext == 'jpg' || $ext == 'jpeg' || $ext == 'gif' || $ext == 'png'){
		if(empty($array[0]) || empty($array[1])){
		$validate = false;
		}else{
		$validate = true;
		}
		}else{
		$validate = false;
		}
	return $validate;
	}
}
?>