-- $Id: 171_upgrade.sql 330 2009-11-23 13:31:20Z fwhite $

-- channel_comments
ALTER TABLE `channel_comments` ADD PRIMARY KEY ( `comment_id` ) ;
ALTER TABLE `channel_comments` CHANGE `comment_id` `comment_id` INT( 11 ) NOT NULL AUTO_INCREMENT;
ALTER TABLE `channel_comments` CHANGE `comment` `comment` TEXT NOT NULL;
ALTER TABLE `channel_comments` CHANGE `username` `username` TEXT NOT NULL;
ALTER TABLE `channel_comments` CHANGE `channel_user` `channel_user` TEXT NOT NULL;

-- config
UPDATE `config` SET `name` = 'allow_reg' WHERE `name` = 'allow_registeration' LIMIT 1 ;
UPDATE `config` SET `value` = '1.7.2 - SVN Revision 330' WHERE `name` = 'version' LIMIT 1 ;
INSERT INTO `config` (`configid`, `name`, `value`) VALUES
(NULL, 'debug_level', '2'),
(NULL, 'session_timeout', '0'),
(NULL, 'google_analytics', ''),
(NULL, 'log_access', '0'),
(NULL, 'release_date', '$Date: 2009-11-23 14:31:20 +0100 (Mon, 23 Nov 2009) $'),
(NULL, 'enable_troubleshooter', '1'),
(NULL , 'check_ffmpeg', '1'),
(NULL , 'allow_contact', '1'),
(NULL , 'installed', '0'),
(NULL , 'installDate', '0'),
(NULL , 'upgradeDate', '0'),
(NULL , 'allowed_video_bitrates', '300k,600k,1000k,same as source'),
(NULL , 'allowed_audio_freq', '22050,44100,48000'),
(NULL , 'allowed_audio_bitrates', '64k,128k,192k,same as source'),
(NULL , 'expert_admin', '0'),
(NULL , 'guest_view_channel_list', '1'),
(NULL , 'guest_view_video_list', '1'),
(NULL , 'guest_view_group_list', '1'),
(NULL , 'guest_view_profiles', '1'),
(NULL , 'use_videnc', '0'),
(NULL , 'videnc_key', '0');

-- contacts
ALTER TABLE `contacts` ADD `userid` INT NULL AFTER `username` ;
ALTER TABLE `contacts` ADD `friend_userid` INT NULL AFTER `friend_username` ;

-- players
ALTER TABLE `players` DROP `template_id`;
ALTER TABLE `players` ADD `player_type` ENUM( 'built-in', 'plugin' ) NOT NULL DEFAULT 'built-in' AFTER `player_file` ;
ALTER TABLE `players` ADD `player_admin_file` TEXT NOT NULL AFTER `player_type` ;
ALTER TABLE `players` ADD `player_include_file` TEXT NOT NULL AFTER `player_admin_file` ;

INSERT INTO `players` (`player_id`, `player_name`, `player_file`) VALUES
(NULL, 'JW Player', 'jw.swf'),
(NULL, 'Ripe FLV Player', 'ripe.swf');

-- stats
UPDATE `stats` SET `value` = '1.7.2' WHERE `name` = 'cb_ver' LIMIT 1 ;
UPDATE `stats` SET `value` = '$Date: 2009-11-23 14:31:20 +0100 (Mon, 23 Nov 2009) $' WHERE `name` = 'date_updated' LIMIT 1 ;
UPDATE `stats` SET `value` = 'SVN Revision 330' WHERE `name` = 'stability' LIMIT 1 ;

INSERT INTO `stats` (`stat_id`, `name`, `value`) VALUES
(NULL, 'release_date', '$Date: 2009-11-23 14:31:20 +0100 (Mon, 23 Nov 2009) $');

-- users
ALTER TABLE `users` CHANGE `password` `password` TEXT NOT NULL ;
ALTER TABLE `users` CHANGE `email` `email` TEXT NOT NULL ;
ALTER TABLE `users` CHANGE `first_name` `first_name` TEXT NOT NULL  ;
ALTER TABLE `users` CHANGE `last_name` `last_name` TEXT NOT NULL  ;
ALTER TABLE `users` CHANGE `level` `level` ENUM( 'Admin', 'User' ) NOT NULL DEFAULT 'User' ;
ALTER TABLE `users` CHANGE `avcode` `avcode` TEXT NULL ;
ALTER TABLE `users` CHANGE `doj` `doj` DATETIME NULL ;
ALTER TABLE `users` CHANGE `total_watched` `total_watched` BIGINT( 20 ) NULL DEFAULT '0' ;
ALTER TABLE `users` CHANGE `total_videos` `total_videos` BIGINT( 20 ) NULL DEFAULT '0' ;
ALTER TABLE `users` CHANGE `total_comments` `total_comments` BIGINT( 20 ) NULL DEFAULT '0' ;
ALTER TABLE `users` CHANGE `background` `background` MEDIUMTEXT NULL ;
ALTER TABLE `users` CHANGE `total_groups` `total_groups` BIGINT( 20 ) NULL DEFAULT '0' ;
UPDATE `users` SET `level` = 'User' WHERE `level` = '' ;

-- video
ALTER TABLE `video` CHANGE `description` `description` MEDIUMTEXT NULL ;
ALTER TABLE `video` CHANGE `broadcast` `broadcast` VARCHAR( 10 ) NOT NULL DEFAULT 'public' ;
ALTER TABLE `video` CHANGE `allow_embedding` `allow_embedding` CHAR( 3 ) NOT NULL DEFAULT 'yes' ;
ALTER TABLE `video` CHANGE `allow_comments` `allow_comments` CHAR( 3 ) NOT NULL DEFAULT 'yes' ;
ALTER TABLE `video` CHANGE `comment_voting` `comment_voting` CHAR( 3 ) NOT NULL DEFAULT 'yes' ;
ALTER TABLE `video` CHANGE `allow_rating` `allow_rating` CHAR( 3 ) NOT NULL DEFAULT 'yes' ;
ALTER TABLE `video` CHANGE `last_viewed` `last_viewed` TIMESTAMP NULL ;
ALTER TABLE `video` CHANGE `date_added` `date_added` TIMESTAMP NULL ;

--
-- Table structure for table `logs_ping`
--

CREATE TABLE IF NOT EXISTS `logs_ping` (
  `logid` int(10) unsigned NOT NULL auto_increment,
  `date` int(11) NOT NULL,
  `video` text collate utf8_unicode_ci,
  `event` enum('ping_after_encode','ping_on_error','ping_after_transfer') collate utf8_unicode_ci NOT NULL,
  `log` text collate utf8_unicode_ci,
  `status` enum('encoded','error','failed','received','success') collate utf8_unicode_ci NOT NULL,
  PRIMARY KEY  (`logid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `logs_ping`
--