<?php
/**
#########################################################################################################
# Copyright (c) 2009 ClipBucket / PHPBucket.com. All Rights Reserved.
# URL:              [url]http://clip-bucket.com[/url]
# Function:         Installer (BigDump ver. 0.29b from 2008-01-19)
# Author:           fwhite
# Author:           Alexey Ozerov (alexey at ozerov dot de)
#                   AJAX & CSV functionalities: Krzysiek Herod (kr81uni at wp dot pl)
# More Info:        http:://www.ozerov.de/bigdump.php
# Language:         PHP
# License:          GPL
# Version:          $Id: bigdump.php 312 2009-11-10 02:12:13Z fwhite $
# Created:          Wednesday, August 26, 2009 / 02:15 PM GMT+1 (fwhite)
# Last Modified:    $Date: 2009-11-10 03:12:13 +0100 (Tue, 10 Nov 2009) $ $Author: fwhite $
# Notice:           Please maintain this section
#########################################################################################################
*/

ob_start();
error_reporting(E_ALL);
ini_set('display_errors', '1');
require_once('config.php');

$error                  = false;
$file                   = false;

// Check PHP version
if (!$error && !function_exists('version_compare'))
{
  $error=true;
  exit("<p class=\"error\">PHP version 4.1.0 is required for BigDump to proceed. You have PHP ".phpversion()." installed. Sorry!</p>\n");
}

define ('BD_VERSION','0.29b');
define ('DATA_CHUNK_LENGTH',16384);  // How many chars are read per time
define ('MAX_QUERY_LINES',300);      // How many lines may be considered to be one query (except text lines)
define ('TESTMODE',false);           // Set to true to process the file without actually accessing the database

header("Expires: Mon, 1 Dec 2003 01:00:00 GMT");
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

@ini_set('auto_detect_line_endings', true);
@set_time_limit(0);

// Database configuration
if(isset($_POST['db_server']))
{
define('DB_SERVER',$_POST['db_server']);
$db_server              = DB_SERVER;
}
if(isset($_POST['db_name']))
{
define('DB_NAME',$_POST['db_name']);
$db_name                = DB_NAME;
}
if(isset($_POST['db_user']))
{
define('DB_USER',$_POST['db_user']);
$db_username            = DB_USER;
}
if(isset($_POST['db_pass']))
{
define('DB_PASS',$_POST['db_pass']);
$db_password            = DB_PASS;
}

if(empty($_POST['version']))
{
$filename               = 'cb_new_install.sql';
}
elseif($_POST['version'] == '1.7.1')
{
$filename               = '171_upgrade.sql';
}
elseif($_POST['version'] == '1.7.1_r605')
{
$filename               = '171_r605_upgrade.sql';
}
$csv_insert_table       = '';
$ajax                   = true;
$linespersession        = 3000;
$delaypersession        = 0;
$comment[]              ='#';
$comment[]              ='-- ';
$db_connection_charset  = 'utf8';

// Clean and strip anything we don't want from user's input [0.27b]
foreach ($_REQUEST as $key => $val)
{
  $val = preg_replace("/[^_A-Za-z0-9-\.&= ]/i",'', $val);
  $_REQUEST[$key] = $val;
}

$Doc                    = file_get_contents('html/bigdump/header.html');
$Doc                    = str_replace('$version', VERSION.' ('.BUILD.')', $Doc);
$Doc                    = str_replace('$step', 'Step 2 of 2: Database Import', $Doc);
$Doc                    = str_replace('$Explain', '', $Doc);
echo $Doc;

// Calculate PHP max upload size (handle settings like 10M or 100K)

if (!$error)
{ $upload_max_filesize=ini_get("upload_max_filesize");
  if (eregi("([0-9]+)K",$upload_max_filesize,$tempregs)) $upload_max_filesize=$tempregs[1]*1024;
  if (eregi("([0-9]+)M",$upload_max_filesize,$tempregs)) $upload_max_filesize=$tempregs[1]*1024*1024;
  if (eregi("([0-9]+)G",$upload_max_filesize,$tempregs)) $upload_max_filesize=$tempregs[1]*1024*1024*1024;
}

// Get the current directory

if (isset($_SERVER["CGIA"]))
  $upload_dir=dirname($_SERVER["CGIA"]);
else if (isset($_SERVER["ORIG_PATH_TRANSLATED"]))
  $upload_dir=dirname($_SERVER["ORIG_PATH_TRANSLATED"]);
else if (isset($_SERVER["ORIG_SCRIPT_FILENAME"]))
  $upload_dir=dirname($_SERVER["ORIG_SCRIPT_FILENAME"]);
else if (isset($_SERVER["PATH_TRANSLATED"]))
  $upload_dir=dirname($_SERVER["PATH_TRANSLATED"]);
else
  $upload_dir=dirname($_SERVER["SCRIPT_FILENAME"]);

// Connect to the database

if (!$error && !TESTMODE)
{ $dbconnection = @mysql_connect($db_server,$db_username,$db_password);
  if ($dbconnection)
    $db = mysql_select_db($db_name);
  if (!$dbconnection || !$db)
  { echo ("<p class=\"error\">ERROR:<BR><BR>Database connection failed:&nbsp;&nbsp;".mysql_error()."</p><BR>");
    echo '<form action="index.php" method="post">';
    echo '<input name="restart" id="restart" type="submit" value="Restart">';
    echo '</form>';
    echo file_get_contents('html/bigdump/footer.html');
    $error=true;
    exit;
  }
  if (!$error && $db_connection_charset!=='')
    @mysql_query("SET NAMES $db_connection_charset", $dbconnection);
}
else
{ $dbconnection = false;
}

if(empty($_POST['version']))
{
// check if DB not empty
$sql            = "SHOW TABLES";
$data           = mysql_query($sql, $dbconnection);
if (mysql_num_rows($data) > 0)
{
    echo('<p class="error">ERROR:&nbsp;&nbsp;Database '.DB_NAME.' is not empty.<BR>Please select an empty database.</p><BR>');
    echo '<form action="index.php" method="post">';
    echo '<input name="restart" id="restart" type="submit" value="Restart">';
    echo '</form>';
    echo file_get_contents('html/bigdump/footer.html');
    $error=true;
    exit;
}
}

// Open the file
if (!$error && isset($_REQUEST["start"]))
{

// Set current filename ($filename overrides $_REQUEST["fn"] if set)

  if ($filename!="")
    $curfilename=$filename;
  else if (isset($_REQUEST["fn"]))
    $curfilename=urldecode($_REQUEST["fn"]);
  else
    $curfilename="";

// Recognize GZip filename

  if (eregi("\.gz$",$curfilename))
    $gzipmode=true;
  else
    $gzipmode=false;

  if ((!$gzipmode && !$file=@fopen($curfilename,"rt")) || ($gzipmode && !$file=@gzopen($curfilename,"rt")))
  { echo ("<p class=\"error\">Can't open ".$curfilename." for import</p>\n");
    echo ("<p class=\"bigdump\">Please, check that your dump file name contains only alphanumerical characters, and rename it accordingly, for example: $curfilename.".
           "<br>Or, specify \$filename in bigdump.php with the full filename. ".
           "<br>Or, you have to upload the $curfilename to the server first.</p>\n");
    $error=true;
  }

// Get the file size (can't do it fast on gzipped files, no idea how)

  else if ((!$gzipmode && @fseek($file, 0, SEEK_END)==0) || ($gzipmode && @gzseek($file, 0)==0))
  { if (!$gzipmode) $filesize = ftell($file);
    else $filesize = gztell($file);                   // Always zero, ignore
  }
  else
  { echo ("<p class=\"error\">I can't seek into $curfilename</p>\n");
    $error=true;
  }
}

// *******************************************************************************************
// START IMPORT SESSION HERE
// *******************************************************************************************

if (!$error && isset($_REQUEST["start"]) && isset($_REQUEST["foffset"]) && eregi("(\.(sql|gz|csv))$",$curfilename))
{

// Check start and foffset are numeric values

  if (!is_numeric($_REQUEST["start"]) || !is_numeric($_REQUEST["foffset"]))
  { echo ("<p class=\"error\">UNEXPECTED: Non-numeric values for start and foffset</p>\n");
    $error=true;
  }

  if (!$error)
  { $_REQUEST["start"]   = floor($_REQUEST["start"]);
    $_REQUEST["foffset"] = floor($_REQUEST["foffset"]);
    if (TESTMODE)
      echo ("<p class=\"centr\">TEST MODE ENABLED</p>\n");
    echo ("<p class=\"centr\">Processing file: <b>".$curfilename."</b></p>\n");
    echo ("<p class=\"smlcentr\">Starting from line: ".$_REQUEST["start"]."</p>\n");
  }

// Check $_REQUEST["foffset"] upon $filesize (can't do it on gzipped files)

  if (!$error && !$gzipmode && $_REQUEST["foffset"]>$filesize)
  { echo ("<p class=\"error\">UNEXPECTED: Can't set file pointer behind the end of file</p>\n");
    $error=true;
  }

// Set file pointer to $_REQUEST["foffset"]

  if (!$error && ((!$gzipmode && fseek($file, $_REQUEST["foffset"])!=0) || ($gzipmode && gzseek($file, $_REQUEST["foffset"])!=0)))
  { echo ("<p class=\"error\">UNEXPECTED: Can't set file pointer to offset: ".$_REQUEST["foffset"]."</p>\n");
    $error=true;
  }

// Start processing queries from $file

  if (!$error)
  { $query="";
    $queries=0;
    $totalqueries=$_REQUEST["totalqueries"];
    $linenumber=$_REQUEST["start"];
    $querylines=0;
    $inparents=false;

// Stay processing as long as the $linespersession is not reached or the query is still incomplete

    while ($linenumber<$_REQUEST["start"]+$linespersession || $query!="")
    {

// Read the whole next line

      $dumpline = "";
      while (!feof($file) && substr ($dumpline, -1) != "\n")
      { if (!$gzipmode)
          $dumpline .= fgets($file, DATA_CHUNK_LENGTH);
        else
          $dumpline .= gzgets($file, DATA_CHUNK_LENGTH);
      }
      if ($dumpline==="") break;


// Stop if csv file is used, but $csv_insert_table is not set
      if (($csv_insert_table == "") && (eregi("(\.csv)$",$curfilename)))
      {
        echo ("<p class=\"error\">Stopped at the line $linenumber. </p>");
        echo ('<p>At this place the current query is from csv file, but $csv_insert_table was not set.');
        echo ("You have to tell where you want to send your data.</p>\n");
        $error=true;
        break;
      }

// Create an SQL query from CSV line

      if (($csv_insert_table != "") && (eregi("(\.csv)$",$curfilename)))
        $dumpline = 'INSERT INTO '.$csv_insert_table.' VALUES ('.$dumpline.');';

// Handle DOS and Mac encoded linebreaks (I don't know if it will work on Win32 or Mac Servers)

      $dumpline=str_replace("\r\n", "\n", $dumpline);
      $dumpline=str_replace("\r", "\n", $dumpline);

// DIAGNOSTIC
// echo ("<p>Line $linenumber: $dumpline</p>\n");

// Skip comments and blank lines only if NOT in parents

      if (!$inparents)
      { $skipline=false;
        reset($comment);
        foreach ($comment as $comment_value)
        { if (!$inparents && (trim($dumpline)=="" || strpos ($dumpline, $comment_value) === 0))
          { $skipline=true;
            break;
          }
        }
        if ($skipline)
        { $linenumber++;
          continue;
        }
      }

// Remove double back-slashes from the dumpline prior to count the quotes ('\\' can only be within strings)

      $dumpline_deslashed = str_replace ("\\\\","",$dumpline);

// Count ' and \' in the dumpline to avoid query break within a text field ending by ;
// Please don't use double quotes ('"')to surround strings, it wont work

      $parents=substr_count ($dumpline_deslashed, "'")-substr_count ($dumpline_deslashed, "\\'");
      if ($parents % 2 != 0)
        $inparents=!$inparents;

// Add the line to query

      $query .= $dumpline;

// Don't count the line if in parents (text fields may include unlimited linebreaks)

      if (!$inparents)
        $querylines++;

// Stop if query contains more lines as defined by MAX_QUERY_LINES

      if ($querylines>MAX_QUERY_LINES)
      {
        echo ("<p class=\"error\">Stopped at the line $linenumber. </p>");
        echo ("<p>At this place the current query includes more than ".MAX_QUERY_LINES." dump lines. That can happen if your dump file was ");
        echo ("created by some tool which doesn't place a semicolon followed by a linebreak at the end of each query, or if your dump contains ");
        echo ("extended inserts. Please read the BigDump FAQs for more infos.</p>\n");
        $error=true;
        break;
      }

// Execute query if end of query detected (; as last character) AND NOT in parents

      if (ereg(";$",trim($dumpline)) && !$inparents)
      { if (!TESTMODE && !mysql_query(trim($query), $dbconnection))
        { echo ("<p class=\"error\">Error at the line $linenumber: ". trim($dumpline)."</p>\n");
          echo ("<p>Query: ".trim(nl2br(htmlentities($query)))."</p>\n");
          echo ("<p>MySQL: ".mysql_error()."</p>\n");
          $error=true;
          break;
        }
        $totalqueries++;
        $queries++;
        $query="";
        $querylines=0;
      }
      $linenumber++;
    }
  }

// Get the current file position

  if (!$error)
  { if (!$gzipmode)
      $foffset = ftell($file);
    else
      $foffset = gztell($file);
    if (!$foffset)
    { echo ("<p class=\"error\">UNEXPECTED: Can't read the file pointer offset</p>\n");
      $error=true;
    }
  }

// Print statistics
// echo ("<p class=\"centr\"><b>Statistics</b></p>\n");

  if (!$error)
  {
    $lines_this   = $linenumber-$_REQUEST["start"];
    $lines_done   = $linenumber-1;
    $lines_togo   = ' ? ';
    $lines_tota   = ' ? ';

    $queries_this = $queries;
    $queries_done = $totalqueries;
    $queries_togo = ' ? ';
    $queries_tota = ' ? ';

    $bytes_this   = $foffset-$_REQUEST["foffset"];
    $bytes_done   = $foffset;
    $kbytes_this  = round($bytes_this/1024,2);
    $kbytes_done  = round($bytes_done/1024,2);
    $mbytes_this  = round($kbytes_this/1024,2);
    $mbytes_done  = round($kbytes_done/1024,2);

    if (!$gzipmode)
    {
      $bytes_togo  = $filesize-$foffset;
      $bytes_tota  = $filesize;
      $kbytes_togo = round($bytes_togo/1024,2);
      $kbytes_tota = round($bytes_tota/1024,2);
      $mbytes_togo = round($kbytes_togo/1024,2);
      $mbytes_tota = round($kbytes_tota/1024,2);

      $pct_this   = ceil($bytes_this/$filesize*100);
      $pct_done   = ceil($foffset/$filesize*100);
      $pct_togo   = 100 - $pct_done;
      $pct_tota   = 100;

      if ($bytes_togo==0)
      { $lines_togo   = '0';
        $lines_tota   = $linenumber-1;
        $queries_togo = '0';
        $queries_tota = $totalqueries;
      }

      $pct_bar    = "<div style=\"height:15px;width:$pct_done%;background-color:#000080;margin:0px;\"></div>";
    }
    else
    {
      $bytes_togo  = ' ? ';
      $bytes_tota  = ' ? ';
      $kbytes_togo = ' ? ';
      $kbytes_tota = ' ? ';
      $mbytes_togo = ' ? ';
      $mbytes_tota = ' ? ';

      $pct_this    = ' ? ';
      $pct_done    = ' ? ';
      $pct_togo    = ' ? ';
      $pct_tota    = 100;
      $pct_bar     = str_replace(' ','&nbsp;','<tt>[         Not available for gzipped files          ]</tt>');
    }

    echo ("
    <center>
    <table width=\"520\" border=\"0\" cellpadding=\"3\" cellspacing=\"1\">
    <tr><th class=\"bg4\"> </th><th class=\"bg4\">Session</th><th class=\"bg4\">Done</th><th class=\"bg4\">To go</th><th class=\"bg4\">Total</th></tr>
    <tr><th class=\"bg4\">Lines</th><td class=\"bg3\">$lines_this</td><td class=\"bg3\">$lines_done</td><td class=\"bg3\">$lines_togo</td><td class=\"bg3\">$lines_tota</td></tr>
    <tr><th class=\"bg4\">Queries</th><td class=\"bg3\">$queries_this</td><td class=\"bg3\">$queries_done</td><td class=\"bg3\">$queries_togo</td><td class=\"bg3\">$queries_tota</td></tr>
    <tr><th class=\"bg4\">Bytes</th><td class=\"bg3\">$bytes_this</td><td class=\"bg3\">$bytes_done</td><td class=\"bg3\">$bytes_togo</td><td class=\"bg3\">$bytes_tota</td></tr>
    <tr><th class=\"bg4\">KB</th><td class=\"bg3\">$kbytes_this</td><td class=\"bg3\">$kbytes_done</td><td class=\"bg3\">$kbytes_togo</td><td class=\"bg3\">$kbytes_tota</td></tr>
    <tr><th class=\"bg4\">MB</th><td class=\"bg3\">$mbytes_this</td><td class=\"bg3\">$mbytes_done</td><td class=\"bg3\">$mbytes_togo</td><td class=\"bg3\">$mbytes_tota</td></tr>
    <tr><th class=\"bg4\">%</th><td class=\"bg3\">$pct_this</td><td class=\"bg3\">$pct_done</td><td class=\"bg3\">$pct_togo</td><td class=\"bg3\">$pct_tota</td></tr>
    <tr><th class=\"bg4\">% bar</th><td class=\"bgpctbar\" colspan=\"4\">$pct_bar</td></tr>
    </table>
    </center>
    \n");

    // Finish message and restart the script

    if ($linenumber<$_REQUEST["start"]+$linespersession)
    {
    $installLock    = "install.lock";
    $FileHandle     = fopen($installLock, 'w') or die("can't write install.lock");
    fclose($FileHandle);
    if(file_exists(BASEDIR.'/files/temp/install.me'))
    {
    unlink(BASEDIR.'/files/temp/install.me');
    }

    if(empty($_POST['version']))
    {
    $sql          = "UPDATE config SET value = '".SERVER_URL."' WHERE name = 'baseurl' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());

    $sql          = "UPDATE config SET value = '".BASEDIR."' WHERE name = 'basedir' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());

    $sql          = "UPDATE config SET value = '".PHP_LOC."' WHERE name = 'php_path' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());
    }

    $sql          = "UPDATE config SET value = '1' WHERE name = 'installed' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());

    $sql          = "UPDATE config SET value = '".REL_DATE."' WHERE name = 'release_date' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());

    if(empty($_POST['version']))
    {
    $sql          = "UPDATE config SET value = '".time()."' WHERE name = 'installDate' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());

    if(defined('FFMPEG_LOC'))
    {
    $sql          = "UPDATE config SET value = '".FFMPEG_LOC."' WHERE name = 'ffmpegpath' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());
    }

    if(defined('FLVTOOL2_LOC'))
    {
    $sql          = "UPDATE config SET value = '".FLVTOOL2_LOC."' WHERE name = 'flvpath' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());
    }
    }

    if(!empty($_POST['version']))
    {
    $sql          = "UPDATE config SET value = '".time()."' WHERE name = 'upgradeDate' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());

    $sql          = "UPDATE stats SET value = '".date("F d, Y")."' WHERE name = 'date_updated' LIMIT 1";
    mysql_query($sql, $dbconnection) or die(mysql_error());
    }

    if(empty($_POST['version']))
    {
    $dbFile     = BASEDIR.'/includes/dbconnect.php';
    $fh         = fopen($dbFile, 'w') or die("can't write dbconnect.php");
    $Doc        = file_get_contents('dbconnect.php');
    $Doc        = str_replace('_DB_HOST_', DB_SERVER, $Doc);
    $Doc        = str_replace('_DB_NAME_', DB_NAME, $Doc);
    $Doc        = str_replace('_DB_USER_', DB_USER, $Doc);
    $Doc        = str_replace('_DB_PASS_', DB_PASS, $Doc);
    fwrite($fh, $Doc) or die("can't write dbconnect.php");
    fclose($fh);
    }
    else
    {
    $dbFile     = BASEDIR.'/includes/dbconnect.php';
    $fh         = fopen($dbFile, 'w') or die("can't write dbconnect.php");
    $Doc        = file_get_contents('dbconnect_upgrade.php');
    $Doc        = str_replace('_DB_HOST_', DB_SERVER, $Doc);
    $Doc        = str_replace('_DB_NAME_', DB_NAME, $Doc);
    $Doc        = str_replace('_DB_USER_', DB_USER, $Doc);
    $Doc        = str_replace('_DB_PASS_', DB_PASS, $Doc);
    fwrite($fh, $Doc) or die("can't write dbconnect.php");
    fclose($fh);
    }

    echo ("<p class=\"successcentr\">Database import complete.<BR><BR>Install complete.
    <BR>Click Login below.</p>\n");

    if(empty($_POST['version']))
    {
    echo '<form action="'.SERVER_URL.'/signup.php" method="post">';
    echo '<input type="hidden" name="returnto" value="'.SERVER_URL.'/myaccount.php">';
    echo '<input type="hidden" name="username" value="admin">';
	echo '<input type="hidden" name="password" value="admin">';
    echo '<input name="login" id="login" type="submit" value="Login">';
    echo '</form>';
    }
    else
    {
    echo '<button onclick="location.href=\''.SERVER_URL.'\'">Login</button>';
    }
    echo file_get_contents('html/bigdump/footer.html');

/*    $htaccess   = '.htaccess';
    $fh         = fopen($htaccess, 'w') or die("can't write .htaccess");
    fwrite($fh, 'deny from all') or die("can't write .htaccess");
    fclose($fh);*/
    
    exit;
    }
    else
    { if ($delaypersession!=0)
        echo ("<p class=\"centr\">Now I'm <b>waiting $delaypersession milliseconds</b> before starting next session...</p>\n");
        if (!$ajax)
          echo ("<script language=\"JavaScript\" type=\"text/javascript\">window.setTimeout('location.href=\"".$_SERVER["PHP_SELF"]."?start=$linenumber&fn=".urlencode($curfilename)."&foffset=$foffset&totalqueries=$totalqueries\";',500+$delaypersession);</script>\n");
        echo ("<noscript>\n");
        echo ("<p class=\"centr\"><a href=\"".$_SERVER["PHP_SELF"]."?start=$linenumber&amp;fn=".urlencode($curfilename)."&amp;foffset=$foffset&amp;totalqueries=$totalqueries\">Continue from the line $linenumber</a> (Enable JavaScript to do it automatically)</p>\n");
        echo ("</noscript>\n");

      echo ("<p class=\"centr\">Press <b><a href=\"".$_SERVER["PHP_SELF"]."\">STOP</a></b> to abort the import <b>OR WAIT!</b></p>\n");
    }
  }
  else
    echo ("<p class=\"error\">Stopped on error</p>\n");
}

if ($error)
  //echo ("<p class=\"centr\"><a href=\"".$_SERVER["PHP_SELF"]."\">Start from the beginning</a> (DROP the old tables before restarting)</p>\n");

if ($dbconnection) mysql_close();
if ($file && !$gzipmode) fclose($file);
else if ($file && $gzipmode) gzclose($file);

// *******************************************************************************************
// 				AJAX functionality starts here
// *******************************************************************************************

// Handle special situations (errors, and finish)

if ($error)
{
  $out1 = ob_get_contents();
  ob_end_clean();
  echo $out1;
  die;
}

// Creates responses  (XML only or web page)

if (($ajax) && isset($_REQUEST['start']))
{
  if (isset($_REQUEST['ajaxrequest']))
  {	ob_end_clean();
		create_xml_response();
		die;
	}
	else
	{
	  create_ajax_script();
	}
}
ob_flush();

// *******************************************************************************************
// 				AJAX utilities
// *******************************************************************************************

function create_xml_response()
{
  global $linenumber, $foffset, $totalqueries, $curfilename,
				 $lines_this, $lines_done, $lines_togo, $lines_tota,
				 $queries_this, $queries_done, $queries_togo, $queries_tota,
				 $bytes_this, $bytes_done, $bytes_togo, $bytes_tota,
				 $kbytes_this, $kbytes_done, $kbytes_togo, $kbytes_tota,
				 $mbytes_this, $mbytes_done, $mbytes_togo, $mbytes_tota,
				 $pct_this, $pct_done, $pct_togo, $pct_tota,$pct_bar;

	//echo "Content-type: application/xml; charset='iso-8859-1'";
	header('Content-Type: application/xml');
	header('Cache-Control: no-cache');
	/*
	echo '<?xml version="1.0"?>'."\n";
	echo '<root>'."\n";
	echo 'cos'."\n";
	echo '</root>'."\n";
	*/

	echo '<?xml version="1.0" encoding="ISO-8859-1"?>';
	echo "<root>";
	// data - for calculations
	echo "<linenumber>";
	echo "$linenumber";
	echo "</linenumber>";
	echo "<foffset>";
	echo "$foffset";
	echo "</foffset>";
	echo "<fn>";
	echo '"'.$curfilename.'"';
	echo "</fn>";
	echo "<totalqueries>";
	echo "$totalqueries";
	echo "</totalqueries>";
	// results - for form update
	echo "<elem1>";
	echo "$lines_this";
	echo "</elem1>";
	echo "<elem2>";
	echo "$lines_done";
	echo "</elem2>";
	echo "<elem3>";
	echo "$lines_togo";
	echo "</elem3>";
	echo "<elem4>";
	echo "$lines_tota";
	echo "</elem4>";

	echo "<elem5>";
	echo "$queries_this";
	echo "</elem5>";
	echo "<elem6>";
	echo "$queries_done";
	echo "</elem6>";
	echo "<elem7>";
	echo "$queries_togo";
	echo "</elem7>";
	echo "<elem8>";
	echo "$queries_tota";
	echo "</elem8>";

	echo "<elem9>";
	echo "$bytes_this";
	echo "</elem9>";
	echo "<elem10>";
	echo "$bytes_done";
	echo "</elem10>";
	echo "<elem11>";
	echo "$bytes_togo";
	echo "</elem11>";
	echo "<elem12>";
	echo "$bytes_tota";
	echo "</elem12>";

	echo "<elem13>";
	echo "$kbytes_this";
	echo "</elem13>";
	echo "<elem14>";
	echo "$kbytes_done";
	echo "</elem14>";
	echo "<elem15>";
	echo "$kbytes_togo";
	echo "</elem15>";
	echo "<elem16>";
	echo "$kbytes_tota";
	echo "</elem16>";

	echo "<elem17>";
	echo "$mbytes_this";
	echo "</elem17>";
	echo "<elem18>";
	echo "$mbytes_done";
	echo "</elem18>";
	echo "<elem19>";
	echo "$mbytes_togo";
	echo "</elem19>";
	echo "<elem20>";
	echo "$mbytes_tota";
	echo "</elem20>";

	echo "<elem21>";
	echo "$pct_this";
	echo "</elem21>";
	echo "<elem22>";
	echo "$pct_done";
	echo "</elem22>";
	echo "<elem23>";
	echo "$pct_togo";
	echo "</elem23>";
	echo "<elem24>";
	echo "$pct_tota";
	echo "</elem24>";

	// converting html to normal text
	$pct_bar    = htmlentities($pct_bar);
	echo "<elem_bar>";
	echo "$pct_bar";
	echo "</elem_bar>";

	echo "</root>";

}

function create_ajax_script()
{
  global $linenumber, $foffset, $totalqueries, $delaypersession, $curfilename;
	?>
	<script type="text/javascript" language="javascript">

	// creates next action url (upload page, or XML response)
	function get_url(linenumber,fn,foffset,totalqueries) {
		return "<?php echo $_SERVER['PHP_SELF'] ?>?start="+linenumber+"&fn="+fn+"&foffset="+foffset+"&totalqueries="+totalqueries+"&ajaxrequest=true";
	}

	// extracts text from XML element (itemname must be unique)
	function get_xml_data(itemname,xmld) {
		return xmld.getElementsByTagName(itemname).item(0).firstChild.data;
	}

	// action url (upload page)
	var url_request =  get_url(<?php echo $linenumber.',"'.urlencode($curfilename).'",'.$foffset.','.$totalqueries;?>);
	var http_request = false;

	function makeRequest(url) {
		http_request = false;
		if (window.XMLHttpRequest) {
		// Mozilla,...
			http_request = new XMLHttpRequest();
			if (http_request.overrideMimeType) {
				http_request.overrideMimeType("text/xml");
			}
		} else if (window.ActiveXObject) {
		// IE
			try {
				http_request = new ActiveXObject("Msxml2.XMLHTTP");
			} catch(e) {
				try {
					http_request = new ActiveXObject("Microsoft.XMLHTTP");
				} catch(e) {}
			}
		}
		if (!http_request) {
				alert("Cannot create an XMLHTTP instance");
				return false;
		}
		http_request.onreadystatechange = server_response;
		http_request.open("GET", url, true);
		http_request.send(null);
	}

	function server_response()
	{

	  // waiting for correct response
	  if (http_request.readyState != 4)
			return;
	  if (http_request.status != 200) {
	    alert("Page unavailable, or wrong url!")
			return;
		}

		// r = xml response
		var r = http_request.responseXML;

		//if received not XML but HTML with new page to show
		if (r.getElementsByTagName('root').length == 0) {                   	//*
			var text = http_request.responseText;
			document.open();
			document.write(text);
			document.close();
			return;
		}

		// update "Starting from line: "
		document.getElementsByTagName('p').item(1).innerHTML =
			"Starting from line: " +
			   r.getElementsByTagName('linenumber').item(0).firstChild.nodeValue;

		// update table with new values
		for(i = 1; i <= 24; i++) {
			document.getElementsByTagName('td').item(i).firstChild.data =
				get_xml_data('elem'+i,r);
		}

		// update color bar
		document.getElementsByTagName('td').item(25).innerHTML =
			r.getElementsByTagName('elem_bar').item(0).firstChild.nodeValue;

		// action url (XML response)
		url_request =  get_url(
			get_xml_data('linenumber',r),
			get_xml_data('fn',r),
			get_xml_data('foffset',r),
			get_xml_data('totalqueries',r));

		// ask for XML response
		window.setTimeout("makeRequest(url_request)",500+<?php echo $delaypersession; ?>);
	}
	// ask for upload page
	window.setTimeout("makeRequest(url_request)",500+<?php echo $delaypersession; ?>);
	</script>
	<?php
}
?>